using UnityEngine;
using System.Collections;

public class s_PlayerMessage : MonoBehaviour
{
	public GUIStyle mStyle;
	
	Color mColor = Color.white;		//The color that is used for changing the alpha
	bool  mFadeIn = false;			//Checks which direction you are fading
	bool  mFadeStarted = false;		//Checks when to start fading in and out
	bool  mFadeRunning = false; 	//Checks if the Fade coroutine is running
	int   mPreviousRewindSpeed; 	//What the last rewind speed was
	float mFadeStartDelay = 1.0f;	//How much time before rewind speed starts fading
	float mFadeClamp = 0.2f;		//How far the fade in and out can go (example: 0.2 will fade in and out from 0.2-0.8)
	
	float mFadeSpeed = 2.0f * 0.033f; //How fast rewind speed fades. Not using deltaTime because I need it to update even when timescale=0
	float mFadeInOutSpeed = 1.0f * 0.033f; //Speed for fading in and out (the shift message)
	
	void Start()
	{
		s_TimeManager.Get.AddStartFunction(RewindStart);
		s_TimeManager.Get.AddChangeFunction(RewindChange);
		
		mColor.a = 0;
	}
	
	void RewindStart()
	{
		StopCoroutine("FadeInAndOut");
		mFadeStarted = false;
	}
	
	void RewindChange()
	{
		//Reset
		mColor.a = 1;
		StopCoroutine("FadeOutAfterTime");
		StopCoroutine("Fade");
		
		//Set
		mFadeRunning = true;
		mPreviousRewindSpeed = s_TimeManager.sRewindSpeed;
		StartCoroutine("FadeOutAfterTime", mFadeStartDelay);
	}
	
	void OnGUI()
	{
		//Show the rewind speed when rewinding
		//if (!s_Player.sDead && mColor.a > 0)
		if (mFadeRunning)
		{
		    Vector3 ScreenToWorldPosition = Camera.main.WorldToScreenPoint(transform.position);
			
			GUI.color = mColor;
			if (s_TimeManager.sRewind)
		    	GUI.Label(new Rect(ScreenToWorldPosition.x - 8, Screen.height - (ScreenToWorldPosition.y + 20), 100, 20), s_TimeManager.sRewindSpeed + "x", mStyle);
			else
				GUI.Label(new Rect(ScreenToWorldPosition.x - 8, Screen.height - (ScreenToWorldPosition.y + 20), 100, 20), mPreviousRewindSpeed + "x", mStyle);
		}
		else if (s_Player.sDead && !s_TimeManager.sRewind)
		{
			if (!mFadeStarted)
			{
				mFadeStarted = true;
				StartCoroutine("FadeInAndOut");
				mColor.a = 1.0f;
			}
			
			Vector3 ScreenToWorldPosition = Camera.main.WorldToScreenPoint(transform.position);
			
			GUI.color = mColor;
			
			GUI.Label(new Rect(ScreenToWorldPosition.x - 8, Screen.height - (ScreenToWorldPosition.y + 20), 100, 20), "SHIFT", mStyle);
		}
	}
	
	IEnumerator FadeOutAfterTime(float aTime)
	{
		yield return new WaitForSeconds(aTime);
		StartCoroutine("Fade");
	}
	
	IEnumerator Fade()
	{
		while (mColor.a > 0)
		{
			mColor.a -= mFadeSpeed;
			yield return null;
		}
		
		mFadeRunning = false;
	}
	
	IEnumerator FadeInAndOut()
	{
		while (true) //Starting the rewind stops it
		{
			if (mFadeIn)
				mColor.a += mFadeInOutSpeed;
			else
				mColor.a -= mFadeInOutSpeed;
			
			if (mFadeIn && mColor.a >= 1.0f - mFadeClamp)
				mFadeIn = false;
			else if (!mFadeIn && mColor.a <= mFadeClamp)
				mFadeIn = true;
			
			yield return null;
		}
	}
}
